#pragma once

#include <string>
#include <afx.h>

using std::string;

//////////////////////////////////////////////////////////////////////////////////////
#define kSimFileMf						"3F00"
#define kSimFileDfTelecom				"7F10"
#define kSimFileDfGraphics				"5F50"
#define kSimFileDfGsm					"7F20"
#define kSimFileDfSolsa					"5F70"
#define kSimFileTypeUnknown				0x00
#define kSimFileTypeMaster				0x01
#define kSimFileTypeDedicated			0x02
#define kSimFileTypeElementary			0x04
#define kSimFileStructureUnknown		0xFF
#define kSimFileStructureTransparent	0x00
#define kSimFileStructureLinearFixed	0x01
#define kSimFileStructureCyclic			0x03
#define kSimInvalidRecordNumber			0x00
#define kSimRecordAccessNext			0x02
#define kSimRecordAccessPrevious		0x03
#define kSimRecordAccessAbsolute		0x04
#define kAPDUCmdDetailStart				"810301"
#define kAPDUDeviceIdentifiers			"82028182"	//(SIM->ME)
#define kSimAppsDataBaseFileName		"SimApps"
#define kSatMenuTitleText				"Network Services+"
//////////////////////////////////////////////////////////////////////////////////////
#define kVPPath							"."
//////////////////////////////////////////////////////////////////////////////////////
#ifdef DLLMANAGER_EXPORTS
	#define DLLMANAGER_API __declspec(dllexport)
#else
	#define DLLMANAGER_API __declspec(dllimport) 
#endif
//////////////////////////////////////////////////////////////////////////////////////
class DLLMANAGER_API CSimFile
{
protected:
	string		path;
	int			bodySize;
	int			type;
	int			structure;
	int			recordSize;
	int			currentRecord;
protected:
	bool GetElementaryFileProperties(const char* iSystemFilePath);
public:
	CSimFile();
	bool Select(const char* iFilePath);
	bool SelectNeighbor(const char* iFileID);
	bool GetSelectResponse(string* ioResponse) const;
	bool HandleReadBinary(const unsigned short iOffset, const unsigned short iSize, unsigned short* ioStatusWords, string* ioResponse) const;
	bool HandleReadRecord(const unsigned short iAccessMode, const unsigned short iRecordNumber, const unsigned short iSize, unsigned short* ioStatusWords, string* ioResponse);
};
//////////////////////////////////////////////////////////////////////////////////////
static CString GetVPPath()
{
	// Warning, SimApps dir has to be is same level as VP .exe and 3F00 dir
	char buf[255];
	memset(buf,0,255);
	GetCurrentDirectory(sizeof(buf),buf);	
	//Warning, 3F00 dir must be at the same as SimApps	
	CString cPath(buf);
	int simpath=cPath.Find("\\SimApps");
	if (simpath>-1)
		cPath=cPath.Left(simpath);
	return cPath;
}
//////////////////////////////////////////////////////////////////////////////////////